//=============================================================================
// AddState_Penetrate_Mirror.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/01/11 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 確定付与ステート・ミラーステートプラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * このスクリプトは、ステートの付与を実行する
 * 「itemEffectAddAttackState」関数と、「itemEffectAddNormalState」関数を再定義します
 * 都合上、極力上の方に配置することを推奨します。
 *
 * ステートのメモ欄に
 * <StatePenetrate>と記載することで 
 * そのステートは、確率の影響を受けずに確実に付与されます。
 * ※スキルやアイテムなどに設定されている「付与確率」は無視されます。
 *
 * ステートのメモ欄に
 * <MirrorState:xx>と記載することで 
 * そのステートが付与されたとき、IDxx番のステートを追加で強制付与します。
 *
 * ステートのメモ欄に
 * <BreakState:xx>と記載することで 
 * そのステートが付与されたとき、IDxx番のステートを強制解除します。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {

Game_Action.prototype.itemEffectAddAttackState = function(target, effect) {
    for (const stateId of this.subject().attackStates()) {
        let chance = effect.value1;
        chance *= target.stateRate(stateId);
        chance *= this.subject().attackStatesRate(stateId);
        chance *= this.lukEffectRate(target);
        if ($dataStates[stateId] && $dataStates[stateId].meta && $dataStates[stateId].meta.StatePenetrate){
            chance = 2.0;
        }
        if (Math.random() < chance) {
            target.addState(stateId);
            if ($dataStates[stateId] && $dataStates[stateId].meta && $dataStates[stateId].meta.MirrorState){
                target.addState(Number($dataStates[stateId].meta.MirrorState));
            }
            if ($dataStates[stateId] && $dataStates[stateId].meta && $dataStates[stateId].meta.BreakState){
                target.removeState(Number($dataStates[stateId].meta.BreakState));
            }
            this.makeSuccess(target);
        }
    }
};

Game_Action.prototype.itemEffectAddNormalState = function(target, effect) {
    let chance = effect.value1;
    if (!this.isCertainHit()) {
        chance *= target.stateRate(effect.dataId);
        chance *= this.lukEffectRate(target);
    }
    
    if ($dataStates[effect.dataId] && $dataStates[effect.dataId].meta && $dataStates[effect.dataId].meta.StatePenetrate){
        chance = 2.0;
    }
    if (Math.random() < chance) {
        target.addState(effect.dataId);
        if ($dataStates[effect.dataId] && $dataStates[effect.dataId].meta && $dataStates[effect.dataId].meta.MirrorState){
            target.addState(Number($dataStates[effect.dataId].meta.MirrorState));
        }
        if ($dataStates[effect.dataId] && $dataStates[effect.dataId].meta && $dataStates[effect.dataId].meta.BreakState){
            target.removeState(Number($dataStates[effect.dataId].meta.BreakState));
        }
        this.makeSuccess(target);
    }
};

})();
